---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-Driver Log（ドライバログ）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/ui/DriverLogPage.scala` 行17-156
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` No.13
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` No.13
- E-04: `docs/code-to-docs/画面遷移図.md` DriverLogTab

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは/logs/ | E-01 行150: SparkUITab(parent, "logs") | ○ |
| C-02 | デフォルトlogTypeはdriver.log | E-01 行47: getOrElse(DRIVER_LOG_FILE) | ○ |
| C-03 | デフォルト読み込みバイト数は100KB | E-01 行43: defaultBytes = 100 * 1024 | ○ |
| C-04 | サポートlogTypeはdriver.log/stderr/stdout | E-01 行42: supportedLogTypes定義 | ○ |
| C-05 | DRIVER_LOG_LOCAL_DIR必須 | E-01 行40: require(conf.get(DRIVER_LOG_LOCAL_DIR).nonEmpty) | ○ |
| C-06 | Load Moreボタンがある | E-01 行58-61: moreButton定義 | ○ |
| C-07 | Load Newボタンがある | E-01 行63-66: newButton定義 | ○ |
| C-08 | "End of Log"アラートがある | E-01 行68-71: alertの定義 | ○ |
| C-09 | 表示範囲情報を表示 | E-01 行54-56: range span要素 | ○ |
| C-10 | ログディレクトリパスを表示 | E-01 行80: "Logs at {logDir}" | ○ |
| C-11 | 80vhの固定高さスクロール領域 | E-01 行82: style="height:80vh; overflow:auto" | ○ |
| C-12 | RollingFileAppenderで複数ファイル対応 | E-01 行118: RollingFileAppender.getSortedRolledOverFiles | ○ |
| C-13 | Utils.offsetBytesでバイト範囲読み込み | E-01 行135: Utils.offsetBytes(files, fileLengths, startIndex, endIndex) | ○ |
| C-14 | 不正logType時のエラーメッセージ | E-01 行114: "Error: Log type must be one of ..." | ○ |
| C-15 | 例外時のエラーメッセージ | E-01 行142: "Error getting logs due to exception: " + e.getMessage | ○ |
| C-16 | renderLogメソッドがAJAX API | E-01 行94-103: renderLogメソッド定義 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面仕様がソースコードと完全に一致

## 6) レビュアーチェックリスト（最小）
- [ ] DRIVER_LOG_LOCAL_DIR設定の実運用環境での設定値を確認
- [ ] ログローテーション時のファイルソート順が期待通りか確認
